local t = Def.ActorFrame {}

local stagestotal = PREFSMAN:GetPreference("SongsPerPlay")
local stagesleft = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer()

--Activar con cdigo. Evento, no hace nada; un stage, tampoco...
if not getenv("StageTicks") or IsEventMode() or stagestotal <= 1 then return t end

for i=1,stagestotal do
	t[#t+1] = Def.Quad {
		Name="SongTicks"..i;
		InitCommand=function(self)
			local stagemod = stagestotal/2
			if stagestotal%2 == 0 then
				stagemod = (stagemod)+0.5
			else
				stagemod = math.ceil(stagemod)
			end
			
			self:diffuse(i > stagesleft and 0 or 1,0,0,1);
			self:zoomto(16,16);
			self:x((i-(stagemod))*20);
			self:y(SCREEN_BOTTOM-18);
		end;
		
		CurrentSongChangedMessageCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			self:stopeffect();
			if not song then return end
			
			if i == stagesleft then
				self:glowshift();
			end
			
			if song:IsLong() then
				if i == stagesleft-1 then
					self:glowshift();
				end
			end
			
			if song:IsMarathon() then
				if i == stagesleft-2 or i == stagesleft-1 then
					self:glowshift();
				end
			end
			
			self:effectcolor1(0,0,0,1);
			self:effectcolor2(1,1,1,1);
			self:effectperiod(0.2);
		end;
	}
end

return t